/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.expressionbuilder;

import filenet.vw.api.VWFieldType;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;

class VWGuidPropertyTableModel
extends DefaultTableModel {
    private static final int NUM_COLUMNS = 2;
    protected static final int COL_NAME = 0;
    protected static final int COL_TYPE = 1;
    protected static final String ARRAY_SYMBOL = "[ ]";
    private ArrayList<PropertyInfo> m_propertyInfoList = null;

    public Class getColumnClass(int nColumnIndex) {
        return String.class;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_name;
            }
            case 1: {
                return VWResource.s_type;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_propertyInfoList != null) {
            return this.m_propertyInfoList.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            PropertyInfo propertyInfo = null;
            if (nRowIndex < this.m_propertyInfoList.size()) {
                propertyInfo = this.m_propertyInfoList.get(nRowIndex);
            }
            switch (nColumnIndex) {
                case 0: {
                    if (propertyInfo == null) break;
                    return propertyInfo.m_name;
                }
                case 1: {
                    if (propertyInfo == null) break;
                    return propertyInfo.m_type;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
    }

    protected void reinitialize(CEObjectInfo ceObjInfo) {
        this.m_propertyInfoList = new ArrayList();
        if (ceObjInfo != null) {
            try {
                Object[] propertyNames = ceObjInfo.getPropertyTypeNames();
                if (propertyNames != null) {
                    VWQubbleSort.sort(propertyNames);
                    for (int i = 0; i < propertyNames.length; ++i) {
                        try {
                            String typeString = VWFieldType.getLocalizedString(ceObjInfo.getPropertyType((String)propertyNames[i]));
                            if (ceObjInfo.getPropertyIsArray((String)propertyNames[i])) {
                                typeString = typeString + ARRAY_SYMBOL;
                            }
                            this.m_propertyInfoList.add(new PropertyInfo((String)propertyNames[i], typeString));
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.fireTableDataChanged();
    }

    private static class PropertyInfo {
        String m_name;
        String m_type;

        PropertyInfo(String name, String type) {
            this.m_name = name;
            this.m_type = type;
        }
    }
}

